/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;

public class DistanceFunction
extends GeometryFunction {
    private GeometryFunction.GeometryValue<PointFunction> p1;
    private GeometryFunction.GeometryValue<PointFunction> p2;

    public DistanceFunction(GeometryFunction.GeometryValue<PointFunction> geometryValue, GeometryFunction.GeometryValue<PointFunction> geometryValue2) throws NullPointerException {
        if (geometryValue == null || geometryValue2 == null) {
            throw new NullPointerException("All parameters of the DISTANCE function must be different from null !");
        }
        this.p1 = geometryValue;
        this.p2 = geometryValue2;
    }

    public DistanceFunction(DistanceFunction distanceFunction) throws Exception {
        super(distanceFunction);
        this.p1 = (GeometryFunction.GeometryValue)distanceFunction.p1.getCopy();
        this.p2 = (GeometryFunction.GeometryValue)distanceFunction.p2.getCopy();
    }

    @Override
    public void setCoordinateSystem(ADQLOperand aDQLOperand) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("A DISTANCE function is not associated to a coordinate system !");
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new DistanceFunction(this);
    }

    @Override
    public String getName() {
        return "DISTANCE";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    public final GeometryFunction.GeometryValue<PointFunction> getP1() {
        return this.p1;
    }

    public final void setP1(GeometryFunction.GeometryValue<PointFunction> geometryValue) {
        this.p1 = geometryValue;
    }

    public final GeometryFunction.GeometryValue<PointFunction> getP2() {
        return this.p2;
    }

    public final void setP2(GeometryFunction.GeometryValue<PointFunction> geometryValue) {
        this.p2 = geometryValue;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.p1.getValue(), this.p2.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 2;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.p1.getValue();
            }
            case 1: {
                return this.p2.getValue();
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove a parameter from the function " + this.getName() + " !");
        }
        if (!(aDQLOperand instanceof GeometryFunction.GeometryValue || aDQLOperand instanceof ADQLColumn || aDQLOperand instanceof PointFunction)) {
            throw new Exception("Impossible to replace a GeometryValue/Column/PointFunction by " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
        }
        ADQLOperand aDQLOperand2 = null;
        GeometryFunction.GeometryValue<PointFunction> geometryValue = null;
        switch (n) {
            case 0: {
                aDQLOperand2 = this.p1.getValue();
                if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                    this.p1 = (GeometryFunction.GeometryValue)aDQLOperand;
                    break;
                }
                geometryValue = this.p1;
                break;
            }
            case 1: {
                aDQLOperand2 = this.p2.getValue();
                if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                    this.p2 = (GeometryFunction.GeometryValue)aDQLOperand;
                    break;
                }
                geometryValue = this.p2;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        if (geometryValue != null) {
            if (aDQLOperand instanceof ADQLColumn) {
                geometryValue.setColumn((ADQLColumn)aDQLOperand);
            } else if (aDQLOperand instanceof PointFunction) {
                geometryValue.setGeometry((PointFunction)aDQLOperand);
            }
        }
        return aDQLOperand2;
    }
}

